/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.def1.Def1Union;
import java.util.Objects;

/**
 * Represents the implementation of def1.
 */
public final class Def1 {

    private Def1Union union;

    /**
     * Creates an instance of def1.
     */
    private Def1() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Def1(Def1Union union) {
        this.union = union;
    }

    /**
     * Returns the object of def1 for type union.
     *
     * @param value value of def1 for type union
     * @return def1 for type union
     */
    public static Def1 of(Def1Union value) {
        return new Def1(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public Def1Union union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(Def1Union union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Def1) {
            Def1 other = (Def1) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of def1 fromString input String def1.
     *
     * @param valInString value of input String
     * @return def1
     */
    public static Def1 fromString(String valInString) {
        try {
            Def1Union tmpVal = Def1Union.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
