/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Cont1;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Def1;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Def2;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Def3;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Def6;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Def7;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbDataTypes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbDataTypesOpParam extends InnerModelObject implements YtbDataTypes {
    protected String leaf1;
    protected Def1 leaf2;
    protected byte[] leaf3;
    protected Def1 leaf4;
    protected Class<? extends Type> leaf5;
    protected String leaf6;
    protected BitSet leaf7;
    protected boolean leaf8;
    protected Def2 leaf9;
    protected Def3 leaf10;
    protected boolean leaf11;
    protected byte[] leaf12;
    protected Def1 leaf13;
    protected Def6 leaf14;
    protected Def7 leaf15;
    protected Def1 leaf16;
    protected List<String> ll1;
    protected List<Def1> ll2;
    protected List<byte[]> ll3;
    protected List<Def1> ll4;
    protected List<Class<? extends Type>> ll5;
    protected List<String> ll6;
    protected List<BitSet> ll7;
    protected List<Boolean> ll8;
    protected List<Def2> ll9;
    protected List<Def3> ll10;
    protected List<Boolean> ll11;
    protected List<byte[]> ll12;
    protected List<Def1> ll13;
    protected List<Def6> ll14;
    protected List<Def7> ll15;
    protected List<Def1> ll16;
    protected BitSet valueLeafFlags = new BitSet();
    protected Cont1 cont1;

    @Override
    public String leaf1() {
        return leaf1;
    }

    @Override
    public Def1 leaf2() {
        return leaf2;
    }

    @Override
    public byte[] leaf3() {
        return leaf3;
    }

    @Override
    public Def1 leaf4() {
        return leaf4;
    }

    @Override
    public Class<? extends Type> leaf5() {
        return leaf5;
    }

    @Override
    public String leaf6() {
        return leaf6;
    }

    @Override
    public BitSet leaf7() {
        return leaf7;
    }

    @Override
    public boolean leaf8() {
        return leaf8;
    }

    @Override
    public Def2 leaf9() {
        return leaf9;
    }

    @Override
    public Def3 leaf10() {
        return leaf10;
    }

    @Override
    public boolean leaf11() {
        return leaf11;
    }

    @Override
    public byte[] leaf12() {
        return leaf12;
    }

    @Override
    public Def1 leaf13() {
        return leaf13;
    }

    @Override
    public Def6 leaf14() {
        return leaf14;
    }

    @Override
    public Def7 leaf15() {
        return leaf15;
    }

    @Override
    public Def1 leaf16() {
        return leaf16;
    }

    @Override
    public List<String> ll1() {
        return ll1;
    }

    @Override
    public List<Def1> ll2() {
        return ll2;
    }

    @Override
    public List<byte[]> ll3() {
        return ll3;
    }

    @Override
    public List<Def1> ll4() {
        return ll4;
    }

    @Override
    public List<Class<? extends Type>> ll5() {
        return ll5;
    }

    @Override
    public List<String> ll6() {
        return ll6;
    }

    @Override
    public List<BitSet> ll7() {
        return ll7;
    }

    @Override
    public List<Boolean> ll8() {
        return ll8;
    }

    @Override
    public List<Def2> ll9() {
        return ll9;
    }

    @Override
    public List<Def3> ll10() {
        return ll10;
    }

    @Override
    public List<Boolean> ll11() {
        return ll11;
    }

    @Override
    public List<byte[]> ll12() {
        return ll12;
    }

    @Override
    public List<Def1> ll13() {
        return ll13;
    }

    @Override
    public List<Def6> ll14() {
        return ll14;
    }

    @Override
    public List<Def7> ll15() {
        return ll15;
    }

    @Override
    public List<Def1> ll16() {
        return ll16;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Cont1 cont1() {
        return cont1;
    }

    @Override
    public void leaf1(String leaf1) {
        valueLeafFlags.set(LeafIdentifier.LEAF1.getLeafIndex());
        this.leaf1 = leaf1;
    }

    @Override
    public void leaf2(Def1 leaf2) {
        valueLeafFlags.set(LeafIdentifier.LEAF2.getLeafIndex());
        this.leaf2 = leaf2;
    }

    @Override
    public void leaf3(byte[] leaf3) {
        valueLeafFlags.set(LeafIdentifier.LEAF3.getLeafIndex());
        this.leaf3 = leaf3;
    }

    @Override
    public void leaf4(Def1 leaf4) {
        valueLeafFlags.set(LeafIdentifier.LEAF4.getLeafIndex());
        this.leaf4 = leaf4;
    }

    @Override
    public void leaf5(Class<? extends Type> leaf5) {
        valueLeafFlags.set(LeafIdentifier.LEAF5.getLeafIndex());
        this.leaf5 = leaf5;
    }

    @Override
    public void leaf6(String leaf6) {
        valueLeafFlags.set(LeafIdentifier.LEAF6.getLeafIndex());
        this.leaf6 = leaf6;
    }

    @Override
    public void leaf7(BitSet leaf7) {
        valueLeafFlags.set(LeafIdentifier.LEAF7.getLeafIndex());
        this.leaf7 = leaf7;
    }

    @Override
    public void leaf8(boolean leaf8) {
        valueLeafFlags.set(LeafIdentifier.LEAF8.getLeafIndex());
        this.leaf8 = leaf8;
    }

    @Override
    public void leaf9(Def2 leaf9) {
        valueLeafFlags.set(LeafIdentifier.LEAF9.getLeafIndex());
        this.leaf9 = leaf9;
    }

    @Override
    public void leaf10(Def3 leaf10) {
        valueLeafFlags.set(LeafIdentifier.LEAF10.getLeafIndex());
        this.leaf10 = leaf10;
    }

    @Override
    public void leaf11(boolean leaf11) {
        valueLeafFlags.set(LeafIdentifier.LEAF11.getLeafIndex());
        this.leaf11 = leaf11;
    }

    @Override
    public void leaf12(byte[] leaf12) {
        valueLeafFlags.set(LeafIdentifier.LEAF12.getLeafIndex());
        this.leaf12 = leaf12;
    }

    @Override
    public void leaf13(Def1 leaf13) {
        valueLeafFlags.set(LeafIdentifier.LEAF13.getLeafIndex());
        this.leaf13 = leaf13;
    }

    @Override
    public void leaf14(Def6 leaf14) {
        valueLeafFlags.set(LeafIdentifier.LEAF14.getLeafIndex());
        this.leaf14 = leaf14;
    }

    @Override
    public void leaf15(Def7 leaf15) {
        valueLeafFlags.set(LeafIdentifier.LEAF15.getLeafIndex());
        this.leaf15 = leaf15;
    }

    @Override
    public void leaf16(Def1 leaf16) {
        valueLeafFlags.set(LeafIdentifier.LEAF16.getLeafIndex());
        this.leaf16 = leaf16;
    }

    @Override
    public void ll1(List<String> ll1) {
        valueLeafFlags.set(LeafIdentifier.LL1.getLeafIndex());
        this.ll1 = ll1;
    }

    @Override
    public void ll2(List<Def1> ll2) {
        valueLeafFlags.set(LeafIdentifier.LL2.getLeafIndex());
        this.ll2 = ll2;
    }

    @Override
    public void ll3(List<byte[]> ll3) {
        valueLeafFlags.set(LeafIdentifier.LL3.getLeafIndex());
        this.ll3 = ll3;
    }

    @Override
    public void ll4(List<Def1> ll4) {
        valueLeafFlags.set(LeafIdentifier.LL4.getLeafIndex());
        this.ll4 = ll4;
    }

    @Override
    public void ll5(List<Class<? extends Type>> ll5) {
        valueLeafFlags.set(LeafIdentifier.LL5.getLeafIndex());
        this.ll5 = ll5;
    }

    @Override
    public void ll6(List<String> ll6) {
        valueLeafFlags.set(LeafIdentifier.LL6.getLeafIndex());
        this.ll6 = ll6;
    }

    @Override
    public void ll7(List<BitSet> ll7) {
        valueLeafFlags.set(LeafIdentifier.LL7.getLeafIndex());
        this.ll7 = ll7;
    }

    @Override
    public void ll8(List<Boolean> ll8) {
        valueLeafFlags.set(LeafIdentifier.LL8.getLeafIndex());
        this.ll8 = ll8;
    }

    @Override
    public void ll9(List<Def2> ll9) {
        valueLeafFlags.set(LeafIdentifier.LL9.getLeafIndex());
        this.ll9 = ll9;
    }

    @Override
    public void ll10(List<Def3> ll10) {
        valueLeafFlags.set(LeafIdentifier.LL10.getLeafIndex());
        this.ll10 = ll10;
    }

    @Override
    public void ll11(List<Boolean> ll11) {
        valueLeafFlags.set(LeafIdentifier.LL11.getLeafIndex());
        this.ll11 = ll11;
    }

    @Override
    public void ll12(List<byte[]> ll12) {
        valueLeafFlags.set(LeafIdentifier.LL12.getLeafIndex());
        this.ll12 = ll12;
    }

    @Override
    public void ll13(List<Def1> ll13) {
        valueLeafFlags.set(LeafIdentifier.LL13.getLeafIndex());
        this.ll13 = ll13;
    }

    @Override
    public void ll14(List<Def6> ll14) {
        valueLeafFlags.set(LeafIdentifier.LL14.getLeafIndex());
        this.ll14 = ll14;
    }

    @Override
    public void ll15(List<Def7> ll15) {
        valueLeafFlags.set(LeafIdentifier.LL15.getLeafIndex());
        this.ll15 = ll15;
    }

    @Override
    public void ll16(List<Def1> ll16) {
        valueLeafFlags.set(LeafIdentifier.LL16.getLeafIndex());
        this.ll16 = ll16;
    }

    @Override
    public void cont1(Cont1 cont1) {
        this.cont1 = cont1;
    }

    @Override
    public void addToLl1(String addTo) {
        if (ll1 == null) {
            ll1 = new ArrayList<>();
        }
        ll1.add(addTo);
    }


    @Override
    public void addToLl2(Def1 addTo) {
        if (ll2 == null) {
            ll2 = new ArrayList<>();
        }
        ll2.add(addTo);
    }


    @Override
    public void addToLl3(byte[] addTo) {
        if (ll3 == null) {
            ll3 = new ArrayList<>();
        }
        ll3.add(addTo);
    }


    @Override
    public void addToLl4(Def1 addTo) {
        if (ll4 == null) {
            ll4 = new ArrayList<>();
        }
        ll4.add(addTo);
    }


    @Override
    public void addToLl5(Class<? extends Type> addTo) {
        if (ll5 == null) {
            ll5 = new ArrayList<>();
        }
        ll5.add(addTo);
    }


    @Override
    public void addToLl6(String addTo) {
        if (ll6 == null) {
            ll6 = new ArrayList<>();
        }
        ll6.add(addTo);
    }


    @Override
    public void addToLl7(BitSet addTo) {
        if (ll7 == null) {
            ll7 = new ArrayList<>();
        }
        ll7.add(addTo);
    }


    @Override
    public void addToLl8(Boolean addTo) {
        if (ll8 == null) {
            ll8 = new ArrayList<>();
        }
        ll8.add(addTo);
    }


    @Override
    public void addToLl9(Def2 addTo) {
        if (ll9 == null) {
            ll9 = new ArrayList<>();
        }
        ll9.add(addTo);
    }


    @Override
    public void addToLl10(Def3 addTo) {
        if (ll10 == null) {
            ll10 = new ArrayList<>();
        }
        ll10.add(addTo);
    }


    @Override
    public void addToLl11(Boolean addTo) {
        if (ll11 == null) {
            ll11 = new ArrayList<>();
        }
        ll11.add(addTo);
    }


    @Override
    public void addToLl12(byte[] addTo) {
        if (ll12 == null) {
            ll12 = new ArrayList<>();
        }
        ll12.add(addTo);
    }


    @Override
    public void addToLl13(Def1 addTo) {
        if (ll13 == null) {
            ll13 = new ArrayList<>();
        }
        ll13.add(addTo);
    }


    @Override
    public void addToLl14(Def6 addTo) {
        if (ll14 == null) {
            ll14 = new ArrayList<>();
        }
        ll14.add(addTo);
    }


    @Override
    public void addToLl15(Def7 addTo) {
        if (ll15 == null) {
            ll15 = new ArrayList<>();
        }
        ll15.add(addTo);
    }


    @Override
    public void addToLl16(Def1 addTo) {
        if (ll16 == null) {
            ll16 = new ArrayList<>();
        }
        ll16.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf1, leaf2, leaf3, leaf4, leaf5, leaf6, leaf7, leaf8, leaf9, leaf10, leaf11, leaf12, leaf13, leaf14, leaf15, leaf16, ll1, ll2, ll3, ll4, ll5, ll6, ll7, ll8, ll9, ll10, ll11, ll12, ll13, ll14, ll15, ll16, valueLeafFlags, cont1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbDataTypesOpParam) {
            YtbDataTypesOpParam other = (YtbDataTypesOpParam) obj;
            return
                Objects.deepEquals(leaf1, other.leaf1) &&
                Objects.deepEquals(leaf2, other.leaf2) &&
                Objects.deepEquals(leaf3, other.leaf3) &&
                Objects.deepEquals(leaf4, other.leaf4) &&
                Objects.deepEquals(leaf5, other.leaf5) &&
                Objects.deepEquals(leaf6, other.leaf6) &&
                Objects.deepEquals(leaf7, other.leaf7) &&
                Objects.deepEquals(leaf8, other.leaf8) &&
                Objects.deepEquals(leaf9, other.leaf9) &&
                Objects.deepEquals(leaf10, other.leaf10) &&
                Objects.deepEquals(leaf11, other.leaf11) &&
                Objects.deepEquals(leaf12, other.leaf12) &&
                Objects.deepEquals(leaf13, other.leaf13) &&
                Objects.deepEquals(leaf14, other.leaf14) &&
                Objects.deepEquals(leaf15, other.leaf15) &&
                Objects.deepEquals(leaf16, other.leaf16) &&
                Objects.deepEquals(ll1, other.ll1) &&
                Objects.deepEquals(ll2, other.ll2) &&
                Objects.deepEquals(ll3, other.ll3) &&
                Objects.deepEquals(ll4, other.ll4) &&
                Objects.deepEquals(ll5, other.ll5) &&
                Objects.deepEquals(ll6, other.ll6) &&
                Objects.deepEquals(ll7, other.ll7) &&
                Objects.deepEquals(ll8, other.ll8) &&
                Objects.deepEquals(ll9, other.ll9) &&
                Objects.deepEquals(ll10, other.ll10) &&
                Objects.deepEquals(ll11, other.ll11) &&
                Objects.deepEquals(ll12, other.ll12) &&
                Objects.deepEquals(ll13, other.ll13) &&
                Objects.deepEquals(ll14, other.ll14) &&
                Objects.deepEquals(ll15, other.ll15) &&
                Objects.deepEquals(ll16, other.ll16) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(cont1, other.cont1);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf1=" + leaf1)
            .add("leaf2=" + leaf2)
            .add("leaf3=" + leaf3)
            .add("leaf4=" + leaf4)
            .add("leaf5=" + leaf5)
            .add("leaf6=" + leaf6)
            .add("leaf7=" + leaf7)
            .add("leaf8=" + leaf8)
            .add("leaf9=" + leaf9)
            .add("leaf10=" + leaf10)
            .add("leaf11=" + leaf11)
            .add("leaf12=" + leaf12)
            .add("leaf13=" + leaf13)
            .add("leaf14=" + leaf14)
            .add("leaf15=" + leaf15)
            .add("leaf16=" + leaf16)
            .add("ll1=" + ll1)
            .add("ll2=" + ll2)
            .add("ll3=" + ll3)
            .add("ll4=" + ll4)
            .add("ll5=" + ll5)
            .add("ll6=" + ll6)
            .add("ll7=" + ll7)
            .add("ll8=" + ll8)
            .add("ll9=" + ll9)
            .add("ll10=" + ll10)
            .add("ll11=" + ll11)
            .add("ll12=" + ll12)
            .add("ll13=" + ll13)
            .add("ll14=" + ll14)
            .add("ll15=" + ll15)
            .add("ll16=" + ll16)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("cont1=" + cont1)
            .toString();
    }

    /**
     * Creates an instance of ytbDataTypesOpParam.
     */
    public YtbDataTypesOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}