/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.enumleaflistunion;

/**
 * Represents ENUM data of enumLeafListUnionEnum1.
 */
public enum EnumLeafListUnionEnum1 {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int enumLeafListUnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of enumLeafListUnionEnum1.
     *
     * @param enumLeafListUnionEnum1 value of enumLeafListUnionEnum1
     */
     EnumLeafListUnionEnum1(int enumLeafListUnionEnum1, String schemaName) {
        this.enumLeafListUnionEnum1 = enumLeafListUnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of enumLeafListUnionEnum1 for.
     *
     * @param value value of enumLeafListUnionEnum1 for
     * @return enumLeafListUnionEnum1 for
     */
    public static EnumLeafListUnionEnum1 of(int value) {
        switch (value) {
            case 10:
                return EnumLeafListUnionEnum1.TEN;
            case 100:
                return EnumLeafListUnionEnum1.HUNDRED;
            case 1000:
                return EnumLeafListUnionEnum1.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of enumLeafListUnionEnum1 for.
     *
     * @param value value of enumLeafListUnionEnum1 for
     * @return enumLeafListUnionEnum1 for
     */
    public static EnumLeafListUnionEnum1 of(String value) {
        switch (value) {
            case "ten":
                return EnumLeafListUnionEnum1.TEN;
            case "hundred":
                return EnumLeafListUnionEnum1.HUNDRED;
            case "thousand":
                return EnumLeafListUnionEnum1.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute enumLeafListUnionEnum1.
     *
     * @return enumLeafListUnionEnum1 value of enumLeafListUnionEnum1
     */
    public int enumLeafListUnionEnum1() {
        return enumLeafListUnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
