/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.contenttest.choicecontainer.choicecontainer.predict;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of reproduce.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultReproduce extends InnerModelObject implements Reproduce {
    protected short yangAutoPrefixCatch;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public short yangAutoPrefixCatch() {
        return yangAutoPrefixCatch;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void yangAutoPrefixCatch(short yangAutoPrefixCatch) {
        valueLeafFlags.set(LeafIdentifier.YANGAUTOPREFIXCATCH.getLeafIndex());
        this.yangAutoPrefixCatch = yangAutoPrefixCatch;
    }

    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixCatch, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultReproduce) {
            DefaultReproduce other = (DefaultReproduce) obj;
            return
                Objects.deepEquals(yangAutoPrefixCatch, other.yangAutoPrefixCatch) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixCatch=" + yangAutoPrefixCatch)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultReproduce.
     */
    public DefaultReproduce() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}