/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.updatepolicymodifiable.updatetrigger;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Timeticks;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.updatepolicymodifiable.UpdateTrigger;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of onChange.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultOnChange extends InnerModelObject implements OnChange {
    protected Timeticks dampeningPeriod;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Timeticks dampeningPeriod() {
        return dampeningPeriod;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void dampeningPeriod(Timeticks dampeningPeriod) {
        valueLeafFlags.set(LeafIdentifier.DAMPENINGPERIOD.getLeafIndex());
        this.dampeningPeriod = dampeningPeriod;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dampeningPeriod, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultOnChange) {
            DefaultOnChange other = (DefaultOnChange) obj;
            return
                Objects.deepEquals(dampeningPeriod, other.dampeningPeriod) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("dampeningPeriod=" + dampeningPeriod)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultOnChange.
     */
    public DefaultOnChange() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}