/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.receiverinfo.receivers;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Host;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.PortNumber;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of receiver.
 */
public class ReceiverKeys implements KeyInfo<DefaultReceiver> {
    protected Host address;
    protected PortNumber port;
    /**
     * Returns the attribute address.
     *
     * @return address value of address
     */
    public Host address() {
        return address;
    }

    /**
     * Sets the value to attribute address.
     *
     * @param address value of address
     */
    public void address(Host address) {
        this.address = address;
    }

    /**
     * Returns the attribute port.
     *
     * @return port value of port
     */
    public PortNumber port() {
        return port;
    }

    /**
     * Sets the value to attribute port.
     *
     * @param port value of port
     */
    public void port(PortNumber port) {
        this.port = port;
    }


    @Override
    public int hashCode() {
        return Objects.hash(address, port);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReceiverKeys) {
            ReceiverKeys other = (ReceiverKeys) obj;
            return
                Objects.deepEquals(address, other.address) &&
                Objects.deepEquals(port, other.port);
        }
        return false;
    }
}