/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.receiverinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.receiverinfo.receivers.Receiver;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of receivers.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultReceivers extends InnerModelObject implements Receivers {
    protected List<Receiver> receiver;

    @Override
    public List<Receiver> receiver() {
        return receiver;
    }

    @Override
    public void receiver(List<Receiver> receiver) {
        this.receiver = receiver;
    }

    @Override
    public void addToReceiver(Receiver addTo) {
        if (receiver == null) {
            receiver = new ArrayList<>();
        }
        receiver.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(receiver);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultReceivers) {
            DefaultReceivers other = (DefaultReceivers) obj;
            return
                Objects.deepEquals(receiver, other.receiver);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("receiver=" + receiver)
            .toString();
    }


    /**
     * Creates an instance of defaultReceivers.
     */
    public DefaultReceivers() {
    }

}