/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.establishsubscription;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.Encoding;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.subscriptionpolicynonmodifiable.Target;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of establishSubscriptionInput.
 */
public class DefaultEstablishSubscriptionInput extends InnerModelObject implements EstablishSubscriptionInput {
    protected Encoding encoding;
    protected BitSet valueLeafFlags = new BitSet();
    protected Target target;

    @Override
    public Encoding encoding() {
        return encoding;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Target target() {
        return target;
    }

    @Override
    public void encoding(Encoding encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void target(Target target) {
        this.target = target;
    }

    @Override
    public int hashCode() {
        return Objects.hash(encoding, valueLeafFlags, target);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEstablishSubscriptionInput) {
            DefaultEstablishSubscriptionInput other = (DefaultEstablishSubscriptionInput) obj;
            return
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(target, other.target);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("encoding=" + encoding)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("target=" + target)
            .toString();
    }


    /**
     * Creates an instance of defaultEstablishSubscriptionInput.
     */
    public DefaultEstablishSubscriptionInput() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}