/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

/**
 * Represents the implementation of netconfNotif.
 */
public abstract class NetconfNotif extends Transport {

    /**
     * Returns the attribute netconf-notif.
     *
     * @return netconf-notif value of netconf-notif
     */
    public static String netconfNotifToString() {
        return "netconf-notif";
    }

    /**
     * Returns the object of netconfNotif fromString input String netconfNotif.
     *
     * @param valInString value of input String
     * @return netconfNotif
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("netconf-notif")) {
            return NetconfNotif.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}