/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.augmentedndnetwork;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.LinkId;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.augmentedndnetwork.link.Destination;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.augmentedndnetwork.link.Source;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.augmentedndnetwork.link.SupportingLink;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of link.
 */
public interface Link extends Augmentable  {

    /**
     * Identify the leaf of Link.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents linkId.
         */
        LINKID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute linkId.
     *
     * @return linkId value of linkId
     */
    LinkId linkId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    Source source();

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    Destination destination();

    /**
     * Returns the attribute supportingLink.
     *
     * @return supportingLink list of supportingLink
     */
    List<SupportingLink> supportingLink();

    /**
     * Sets the attribute linkId.
     *
     * @param linkId value of linkId
     */
    void linkId(LinkId linkId);

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(Source source);

    /**
     * Sets the attribute destination.
     *
     * @param destination value of destination
     */
    void destination(Destination destination);

    /**
     * Sets the attribute supportingLink.
     *
     * @param supportingLink list of supportingLink
     */
    void supportingLink(List<SupportingLink> supportingLink);

    /**
     * Adds to the list of supportingLink.
     *
     * @param addTo value of supportingLink
     */
    void addToSupportingLink(SupportingLink addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}