/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of yangIdentifier.
 */
public final class YangIdentifier {

    private String string;

    /**
     * Creates an instance of yangIdentifier.
     */
    private YangIdentifier() {
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public YangIdentifier(String string) {
        this.string = string;
    }

    /**
     * Returns the object of yangIdentifier for type string.
     *
     * @param value value of yangIdentifier for type string
     * @return yangIdentifier for type string
     */
    public static YangIdentifier of(String value) {
        return new YangIdentifier(value);
    }

    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YangIdentifier) {
            YangIdentifier other = (YangIdentifier) obj;
            return
                Objects.deepEquals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        return string;
    }
    /**
     * Returns the object of yangIdentifier fromString input String yangIdentifier.
     *
     * @param valInString value of input String
     * @return yangIdentifier
     */
    public static YangIdentifier fromString(String valInString) {
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
