/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of tributaryProtocolType.
 */
public abstract class TributaryProtocolType {

    /**
     * Returns the attribute tributary-protocol-type.
     *
     * @return tributary-protocol-type value of tributary-protocol-type
     */
    public static String tributaryProtocolTypeToString() {
        return "tributary-protocol-type";
    }

    /**
     * Returns the object of tributaryProtocolType fromString input String tributaryProtocolType.
     *
     * @param valInString value of input String
     * @return tributaryProtocolType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tributary-protocol-type")) {
            return TributaryProtocolType.class;
        } else if (valInString.equals("prot-OTU1")) {
            return ProtOtu1.class;
        } else if (valInString.equals("prot-OTU2")) {
            return ProtOtu2.class;
        } else if (valInString.equals("prot-OTU2e")) {
            return ProtOtu2e.class;
        } else if (valInString.equals("prot-OTU3")) {
            return ProtOtu3.class;
        } else if (valInString.equals("prot-OTU4")) {
            return ProtOtu4.class;
        } else if (valInString.equals("prot-OTUCn")) {
            return ProtOtucn.class;
        } else if (valInString.equals("prot-ODU0")) {
            return ProtOdu0.class;
        } else if (valInString.equals("prot-ODU1")) {
            return ProtOdu1.class;
        } else if (valInString.equals("prot-ODU2")) {
            return ProtOdu2.class;
        } else if (valInString.equals("prot-ODU2e")) {
            return ProtOdu2e.class;
        } else if (valInString.equals("prot-ODU3")) {
            return ProtOdu3.class;
        } else if (valInString.equals("prot-ODU4")) {
            return ProtOdu4.class;
        } else if (valInString.equals("prot-ODUFlex-cbr")) {
            return ProtOduflexCbr.class;
        } else if (valInString.equals("prot-ODUFlex-gfp")) {
            return ProtOduflexGfp.class;
        } else if (valInString.equals("prot-ODUCn")) {
            return ProtOducn.class;
        } else if (valInString.equals("prot-1GbE")) {
            return Prot1Gbe.class;
        } else if (valInString.equals("prot-10GbE-LAN")) {
            return Prot10GbElan.class;
        } else if (valInString.equals("prot-40GbE")) {
            return Prot40Gbe.class;
        } else if (valInString.equals("prot-100GbE")) {
            return Prot100Gbe.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}