/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of protOtu3.
 */
public abstract class ProtOtu3 extends TributaryProtocolType {

    /**
     * Returns the attribute prot-OTU3.
     *
     * @return prot-OTU3 value of prot-OTU3
     */
    public static String protOtu3ToString() {
        return "prot-OTU3";
    }

    /**
     * Returns the object of protOtu3 fromString input String protOtu3.
     *
     * @param valInString value of input String
     * @return protOtu3
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prot-OTU3")) {
            return ProtOtu3.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}