/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of protOdu3.
 */
public abstract class ProtOdu3 extends TributaryProtocolType {

    /**
     * Returns the attribute prot-ODU3.
     *
     * @return prot-ODU3 value of prot-ODU3
     */
    public static String protOdu3ToString() {
        return "prot-ODU3";
    }

    /**
     * Returns the object of protOdu3 fromString input String protOdu3.
     *
     * @param valInString value of input String
     * @return protOdu3
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prot-ODU3")) {
            return ProtOdu3.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}