/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of protOdu2.
 */
public abstract class ProtOdu2 extends TributaryProtocolType {

    /**
     * Returns the attribute prot-ODU2.
     *
     * @return prot-ODU2 value of prot-ODU2
     */
    public static String protOdu2ToString() {
        return "prot-ODU2";
    }

    /**
     * Returns the object of protOdu2 fromString input String protOdu2.
     *
     * @param valInString value of input String
     * @return protOdu2
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prot-ODU2")) {
            return ProtOdu2.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}