/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignalOc3Stm1.
 */
public abstract class ClientSignalOc3Stm1 extends ClientSignal {

    /**
     * Returns the attribute client-signal-OC3_STM1.
     *
     * @return client-signal-OC3_STM1 value of client-signal-OC3_STM1
     */
    public static String clientSignalOc3Stm1ToString() {
        return "client-signal-OC3_STM1";
    }

    /**
     * Returns the object of clientSignalOc3Stm1 fromString input String clientSignalOc3Stm1.
     *
     * @param valInString value of input String
     * @return clientSignalOc3Stm1
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal-OC3_STM1")) {
            return ClientSignalOc3Stm1.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}