/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignalOc192Stm64.
 */
public abstract class ClientSignalOc192Stm64 extends ClientSignal {

    /**
     * Returns the attribute client-signal-OC192_STM64.
     *
     * @return client-signal-OC192_STM64 value of client-signal-OC192_STM64
     */
    public static String clientSignalOc192Stm64ToString() {
        return "client-signal-OC192_STM64";
    }

    /**
     * Returns the object of clientSignalOc192Stm64 fromString input String clientSignalOc192Stm64.
     *
     * @param valInString value of input String
     * @return clientSignalOc192Stm64
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal-OC192_STM64")) {
            return ClientSignalOc192Stm64.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}