/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignalFc400.
 */
public abstract class ClientSignalFc400 extends ClientSignal {

    /**
     * Returns the attribute client-signal-FC400.
     *
     * @return client-signal-FC400 value of client-signal-FC400
     */
    public static String clientSignalFc400ToString() {
        return "client-signal-FC400";
    }

    /**
     * Returns the object of clientSignalFc400 fromString input String clientSignalFc400.
     *
     * @param valInString value of input String
     * @return clientSignalFc400
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal-FC400")) {
            return ClientSignalFc400.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}