/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignal.
 */
public abstract class ClientSignal {

    /**
     * Returns the attribute client-signal.
     *
     * @return client-signal value of client-signal
     */
    public static String clientSignalToString() {
        return "client-signal";
    }

    /**
     * Returns the object of clientSignal fromString input String clientSignal.
     *
     * @param valInString value of input String
     * @return clientSignal
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal")) {
            return ClientSignal.class;
        } else if (valInString.equals("client-signal-1GbE")) {
            return ClientSignal1Gbe.class;
        } else if (valInString.equals("client-signal-10GbE-LAN")) {
            return ClientSignal10GbElan.class;
        } else if (valInString.equals("client-signal-10GbE-WAN")) {
            return ClientSignal10GbEwan.class;
        } else if (valInString.equals("client-signal-40GbE")) {
            return ClientSignal40Gbe.class;
        } else if (valInString.equals("client-signal-100GbE")) {
            return ClientSignal100Gbe.class;
        } else if (valInString.equals("client-signal-OC3_STM1")) {
            return ClientSignalOc3Stm1.class;
        } else if (valInString.equals("client-signal-OC12_STM4")) {
            return ClientSignalOc12Stm4.class;
        } else if (valInString.equals("client-signal-OC48_STM16")) {
            return ClientSignalOc48Stm16.class;
        } else if (valInString.equals("client-signal-OC192_STM64")) {
            return ClientSignalOc192Stm64.class;
        } else if (valInString.equals("client-signal-OC768_STM256")) {
            return ClientSignalOc768Stm256.class;
        } else if (valInString.equals("client-signal-ODU0")) {
            return ClientSignalOdu0.class;
        } else if (valInString.equals("client-signal-ODU1")) {
            return ClientSignalOdu1.class;
        } else if (valInString.equals("client-signal-ODU2")) {
            return ClientSignalOdu2.class;
        } else if (valInString.equals("client-signal-ODU2e")) {
            return ClientSignalOdu2e.class;
        } else if (valInString.equals("client-signal-ODU3")) {
            return ClientSignalOdu3.class;
        } else if (valInString.equals("client-signal-ODU4")) {
            return ClientSignalOdu4.class;
        } else if (valInString.equals("client-signal-ODUFlex-cbr")) {
            return ClientSignalOduflexCbr.class;
        } else if (valInString.equals("client-signal-ODUFlex-gfp")) {
            return ClientSignalOduflexGfp.class;
        } else if (valInString.equals("client-signal-ODUCn")) {
            return ClientSignalOducn.class;
        } else if (valInString.equals("client-signal-FC400")) {
            return ClientSignalFc400.class;
        } else if (valInString.equals("client-signal-FC800")) {
            return ClientSignalFc800.class;
        } else if (valInString.equals("client-signal-FICON-4G")) {
            return ClientSignalFicon4g.class;
        } else if (valInString.equals("client-signal-FICON-8G")) {
            return ClientSignalFicon8g.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}