/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of stateType.
 */
public abstract class StateType {

    /**
     * Returns the attribute state-type.
     *
     * @return state-type value of state-type
     */
    public static String stateTypeToString() {
        return "state-type";
    }

    /**
     * Returns the object of stateType fromString input String stateType.
     *
     * @param valInString value of input String
     * @return stateType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("state-type")) {
            return StateType.class;
        } else if (valInString.equals("state-up")) {
            return StateUp.class;
        } else if (valInString.equals("state-down")) {
            return StateDown.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}