/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of lspEncodingSdh.
 */
public abstract class LspEncodingSdh extends LspEncodingTypes {

    /**
     * Returns the attribute lsp-encoding-sdh.
     *
     * @return lsp-encoding-sdh value of lsp-encoding-sdh
     */
    public static String lspEncodingSdhToString() {
        return "lsp-encoding-sdh";
    }

    /**
     * Returns the object of lspEncodingSdh fromString input String lspEncodingSdh.
     *
     * @param valInString value of input String
     * @return lspEncodingSdh
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("lsp-encoding-sdh")) {
            return LspEncodingSdh.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}