/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetpid;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of teTpIdUnion.
 */
public final class TeTpIdUnion {
    private long uint32;
    private IpAddress ipAddress;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of teTpIdUnion.
     */
    private TeTpIdUnion() {
    }

    /**
     * Creates an instance of uint32.
     *
     * @param uint32 value of uint32
     */
    public TeTpIdUnion(long uint32) {
        setValue.set(0);
        this.uint32 = uint32;
    }

    /**
     * Creates an instance of ipAddress.
     *
     * @param ipAddress value of ipAddress
     */
    public TeTpIdUnion(IpAddress ipAddress) {
        setValue.set(1);
        this.ipAddress = ipAddress;
    }

    /**
     * Returns the object of teTpIdUnion for type uint32.
     *
     * @param value value of teTpIdUnion for type uint32
     * @return teTpIdUnion for type uint32
     */
    public static TeTpIdUnion of(long value) {
        return new TeTpIdUnion(value);
    }

    /**
     * Returns the object of teTpIdUnion for type ipAddress.
     *
     * @param value value of teTpIdUnion for type ipAddress
     * @return teTpIdUnion for type ipAddress
     */
    public static TeTpIdUnion of(IpAddress value) {
        return new TeTpIdUnion(value);
    }

    /**
     * Returns the attribute uint32.
     *
     * @return uint32 value of uint32
     */
    public long uint32() {
        return uint32;
    }
    /**
     * Returns the attribute ipAddress.
     *
     * @return ipAddress value of ipAddress
     */
    public IpAddress ipAddress() {
        return ipAddress;
    }
    /**
     * Sets the attribute uint32.
     *
     * @param uint32 value of uint32
     */
    public void uint32(long uint32) {
        this.uint32 = uint32;
    }
    /**
     * Sets the attribute ipAddress.
     *
     * @param ipAddress value of ipAddress
     */
    public void ipAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint32, ipAddress);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeTpIdUnion) {
            TeTpIdUnion other = (TeTpIdUnion) obj;
            return
                Objects.deepEquals(uint32, other.uint32) &&
                Objects.deepEquals(ipAddress, other.ipAddress);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint32);
        }
        if (setValue.get(1)) {
            return ipAddress.toString();
        }
        return null;
    }
    /**
     * Returns the object of teTpIdUnion fromString input String teTpIdUnion.
     *
     * @param valInString value of input String
     * @return teTpIdUnion
     */
    public static TeTpIdUnion fromString(String valInString) {
        try {
            long tmpVal = Long.parseLong(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            IpAddress tmpVal = IpAddress.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
