/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologiesaugment;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tetopologiesaugment.te.Templates;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of te.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTe extends InnerModelObject implements Te {
    protected Templates templates;

    @Override
    public Templates templates() {
        return templates;
    }

    @Override
    public void templates(Templates templates) {
        this.templates = templates;
    }

    @Override
    public int hashCode() {
        return Objects.hash(templates);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTe) {
            DefaultTe other = (DefaultTe) obj;
            return
                Objects.deepEquals(templates, other.templates);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("templates=" + templates)
            .toString();
    }


    /**
     * Creates an instance of defaultTe.
     */
    public DefaultTe() {
    }

}