/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.tenodestatederivednotification;

import org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of altInformationSources.
 */
public class AltInformationSourcesKeys implements KeyInfo<DefaultAltInformationSources> {
    protected InformationSourceEnum informationSource;
    /**
     * Returns the attribute informationSource.
     *
     * @return informationSource value of informationSource
     */
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    /**
     * Sets the value to attribute informationSource.
     *
     * @param informationSource value of informationSource
     */
    public void informationSource(InformationSourceEnum informationSource) {
        this.informationSource = informationSource;
    }


    @Override
    public int hashCode() {
        return Objects.hash(informationSource);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AltInformationSourcesKeys) {
            AltInformationSourcesKeys other = (AltInformationSourcesKeys) obj;
            return
                Objects.deepEquals(informationSource, other.informationSource);
        }
        return false;
    }
}