/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes;

/**
 * Represents ENUM data of linkProtectionTypeEnum.
 */
public enum LinkProtectionTypeEnum {

    /**
     * Represents unprotected.
     */
    UNPROTECTED(0, "unprotected"),

    /**
     * Represents extra-traffic.
     */
    EXTRA_TRAFFIC(1, "extra-traffic"),

    /**
     * Represents shared.
     */
    SHARED(2, "shared"),

    /**
     * Represents yangAutoPrefix1-for-1.
     */
    YANGAUTOPREFIX1_FOR_1(3, "1-for-1"),

    /**
     * Represents yangAutoPrefix1-plus-1.
     */
    YANGAUTOPREFIX1_PLUS_1(4, "1-plus-1"),

    /**
     * Represents enhanced.
     */
    ENHANCED(5, "enhanced");

    private int linkProtectionTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of linkProtectionTypeEnum.
     *
     * @param linkProtectionTypeEnum value of linkProtectionTypeEnum
     */
     LinkProtectionTypeEnum(int linkProtectionTypeEnum, String schemaName) {
        this.linkProtectionTypeEnum = linkProtectionTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of linkProtectionTypeEnum for.
     *
     * @param value value of linkProtectionTypeEnum for
     * @return linkProtectionTypeEnum for
     */
    public static LinkProtectionTypeEnum of(int value) {
        switch (value) {
            case 0:
                return LinkProtectionTypeEnum.UNPROTECTED;
            case 1:
                return LinkProtectionTypeEnum.EXTRA_TRAFFIC;
            case 2:
                return LinkProtectionTypeEnum.SHARED;
            case 3:
                return LinkProtectionTypeEnum.YANGAUTOPREFIX1_FOR_1;
            case 4:
                return LinkProtectionTypeEnum.YANGAUTOPREFIX1_PLUS_1;
            case 5:
                return LinkProtectionTypeEnum.ENHANCED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of linkProtectionTypeEnum for.
     *
     * @param value value of linkProtectionTypeEnum for
     * @return linkProtectionTypeEnum for
     */
    public static LinkProtectionTypeEnum of(String value) {
        switch (value) {
            case "unprotected":
                return LinkProtectionTypeEnum.UNPROTECTED;
            case "extra-traffic":
                return LinkProtectionTypeEnum.EXTRA_TRAFFIC;
            case "shared":
                return LinkProtectionTypeEnum.SHARED;
            case "1-for-1":
                return LinkProtectionTypeEnum.YANGAUTOPREFIX1_FOR_1;
            case "1-plus-1":
                return LinkProtectionTypeEnum.YANGAUTOPREFIX1_PLUS_1;
            case "enhanced":
                return LinkProtectionTypeEnum.ENHANCED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute linkProtectionTypeEnum.
     *
     * @return linkProtectionTypeEnum value of linkProtectionTypeEnum
     */
    public int linkProtectionTypeEnum() {
        return linkProtectionTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
