/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.tebandwidthtype;

/**
 * Represents ENUM data of teBandwidthTypeEnum.
 */
public enum TeBandwidthTypeEnum {

    /**
     * Represents sPECIFIED.
     */
    SPECIFIED(0, "SPECIFIED"),

    /**
     * Represents aUTO.
     */
    AUTO(1, "AUTO");

    private int teBandwidthTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of teBandwidthTypeEnum.
     *
     * @param teBandwidthTypeEnum value of teBandwidthTypeEnum
     */
     TeBandwidthTypeEnum(int teBandwidthTypeEnum, String schemaName) {
        this.teBandwidthTypeEnum = teBandwidthTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teBandwidthTypeEnum for.
     *
     * @param value value of teBandwidthTypeEnum for
     * @return teBandwidthTypeEnum for
     */
    public static TeBandwidthTypeEnum of(int value) {
        switch (value) {
            case 0:
                return TeBandwidthTypeEnum.SPECIFIED;
            case 1:
                return TeBandwidthTypeEnum.AUTO;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teBandwidthTypeEnum for.
     *
     * @param value value of teBandwidthTypeEnum for
     * @return teBandwidthTypeEnum for
     */
    public static TeBandwidthTypeEnum of(String value) {
        switch (value) {
            case "SPECIFIED":
                return TeBandwidthTypeEnum.SPECIFIED;
            case "AUTO":
                return TeBandwidthTypeEnum.AUTO;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teBandwidthTypeEnum.
     *
     * @return teBandwidthTypeEnum value of teBandwidthTypeEnum
     */
    public int teBandwidthTypeEnum() {
        return teBandwidthTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
