/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.bfdtype;

/**
 * Represents ENUM data of bfdTypeEnum.
 */
public enum BfdTypeEnum {

    /**
     * Represents classical.
     */
    CLASSICAL(0, "classical"),

    /**
     * Represents seamless.
     */
    SEAMLESS(1, "seamless");

    private int bfdTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of bfdTypeEnum.
     *
     * @param bfdTypeEnum value of bfdTypeEnum
     */
     BfdTypeEnum(int bfdTypeEnum, String schemaName) {
        this.bfdTypeEnum = bfdTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of bfdTypeEnum for.
     *
     * @param value value of bfdTypeEnum for
     * @return bfdTypeEnum for
     */
    public static BfdTypeEnum of(int value) {
        switch (value) {
            case 0:
                return BfdTypeEnum.CLASSICAL;
            case 1:
                return BfdTypeEnum.SEAMLESS;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of bfdTypeEnum for.
     *
     * @param value value of bfdTypeEnum for
     * @return bfdTypeEnum for
     */
    public static BfdTypeEnum of(String value) {
        switch (value) {
            case "classical":
                return BfdTypeEnum.CLASSICAL;
            case "seamless":
                return BfdTypeEnum.SEAMLESS;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute bfdTypeEnum.
     *
     * @return bfdTypeEnum value of bfdTypeEnum
     */
    public int bfdTypeEnum() {
        return bfdTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
