/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes;

import java.math.BigInteger;
import java.util.Objects;

/**
 * Represents the implementation of bandwidthMbps.
 */
public final class BandwidthMbps {

    private BigInteger uint64;

    /**
     * Creates an instance of bandwidthMbps.
     */
    private BandwidthMbps() {
    }

    /**
     * Creates an instance of uint64.
     *
     * @param uint64 value of uint64
     */
    public BandwidthMbps(BigInteger uint64) {
        this.uint64 = uint64;
    }

    /**
     * Returns the object of bandwidthMbps for type uint64.
     *
     * @param value value of bandwidthMbps for type uint64
     * @return bandwidthMbps for type uint64
     */
    public static BandwidthMbps of(BigInteger value) {
        return new BandwidthMbps(value);
    }

    /**
     * Returns the attribute uint64.
     *
     * @return uint64 value of uint64
     */
    public BigInteger uint64() {
        return uint64;
    }
    /**
     * Sets the attribute uint64.
     *
     * @param uint64 value of uint64
     */
    public void uint64(BigInteger uint64) {
        this.uint64 = uint64;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint64);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BandwidthMbps) {
            BandwidthMbps other = (BandwidthMbps) obj;
            return
                Objects.deepEquals(uint64, other.uint64);
        }
        return false;
    }

    @Override
    public String toString() {
        return uint64.toString();
    }
    /**
     * Returns the object of bandwidthMbps fromString input String bandwidthMbps.
     *
     * @param valInString value of input String
     * @return bandwidthMbps
     */
    public static BandwidthMbps fromString(String valInString) {
        try {
            BigInteger tmpVal = new BigInteger(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
