/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes;

/**
 * Represents the implementation of backupProtectionNodeLink.
 */
public abstract class BackupProtectionNodeLink extends BackupProtectionType {

    /**
     * Returns the attribute backup-protection-node-link.
     *
     * @return backup-protection-node-link value of backup-protection-node-link
     */
    public static String backupProtectionNodeLinkToString() {
        return "backup-protection-node-link";
    }

    /**
     * Returns the object of backupProtectionNodeLink fromString input String backupProtectionNodeLink.
     *
     * @param valInString value of input String
     * @return backupProtectionNodeLink
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("backup-protection-node-link")) {
            return BackupProtectionNodeLink.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}