/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Counter32;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Counter64;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of statistics.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultStatistics extends InnerModelObject implements Statistics {
    protected DateAndTime discontinuityTime;
    protected Counter64 inOctets;
    protected Counter64 inUnicastPkts;
    protected Counter64 inBroadcastPkts;
    protected Counter64 inMulticastPkts;
    protected Counter32 inDiscards;
    protected Counter32 inErrors;
    protected Counter32 inUnknownProtos;
    protected Counter64 outOctets;
    protected Counter64 outUnicastPkts;
    protected Counter64 outBroadcastPkts;
    protected Counter64 outMulticastPkts;
    protected Counter32 outDiscards;
    protected Counter32 outErrors;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public DateAndTime discontinuityTime() {
        return discontinuityTime;
    }

    @Override
    public Counter64 inOctets() {
        return inOctets;
    }

    @Override
    public Counter64 inUnicastPkts() {
        return inUnicastPkts;
    }

    @Override
    public Counter64 inBroadcastPkts() {
        return inBroadcastPkts;
    }

    @Override
    public Counter64 inMulticastPkts() {
        return inMulticastPkts;
    }

    @Override
    public Counter32 inDiscards() {
        return inDiscards;
    }

    @Override
    public Counter32 inErrors() {
        return inErrors;
    }

    @Override
    public Counter32 inUnknownProtos() {
        return inUnknownProtos;
    }

    @Override
    public Counter64 outOctets() {
        return outOctets;
    }

    @Override
    public Counter64 outUnicastPkts() {
        return outUnicastPkts;
    }

    @Override
    public Counter64 outBroadcastPkts() {
        return outBroadcastPkts;
    }

    @Override
    public Counter64 outMulticastPkts() {
        return outMulticastPkts;
    }

    @Override
    public Counter32 outDiscards() {
        return outDiscards;
    }

    @Override
    public Counter32 outErrors() {
        return outErrors;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void discontinuityTime(DateAndTime discontinuityTime) {
        valueLeafFlags.set(LeafIdentifier.DISCONTINUITYTIME.getLeafIndex());
        this.discontinuityTime = discontinuityTime;
    }

    @Override
    public void inOctets(Counter64 inOctets) {
        valueLeafFlags.set(LeafIdentifier.INOCTETS.getLeafIndex());
        this.inOctets = inOctets;
    }

    @Override
    public void inUnicastPkts(Counter64 inUnicastPkts) {
        valueLeafFlags.set(LeafIdentifier.INUNICASTPKTS.getLeafIndex());
        this.inUnicastPkts = inUnicastPkts;
    }

    @Override
    public void inBroadcastPkts(Counter64 inBroadcastPkts) {
        valueLeafFlags.set(LeafIdentifier.INBROADCASTPKTS.getLeafIndex());
        this.inBroadcastPkts = inBroadcastPkts;
    }

    @Override
    public void inMulticastPkts(Counter64 inMulticastPkts) {
        valueLeafFlags.set(LeafIdentifier.INMULTICASTPKTS.getLeafIndex());
        this.inMulticastPkts = inMulticastPkts;
    }

    @Override
    public void inDiscards(Counter32 inDiscards) {
        valueLeafFlags.set(LeafIdentifier.INDISCARDS.getLeafIndex());
        this.inDiscards = inDiscards;
    }

    @Override
    public void inErrors(Counter32 inErrors) {
        valueLeafFlags.set(LeafIdentifier.INERRORS.getLeafIndex());
        this.inErrors = inErrors;
    }

    @Override
    public void inUnknownProtos(Counter32 inUnknownProtos) {
        valueLeafFlags.set(LeafIdentifier.INUNKNOWNPROTOS.getLeafIndex());
        this.inUnknownProtos = inUnknownProtos;
    }

    @Override
    public void outOctets(Counter64 outOctets) {
        valueLeafFlags.set(LeafIdentifier.OUTOCTETS.getLeafIndex());
        this.outOctets = outOctets;
    }

    @Override
    public void outUnicastPkts(Counter64 outUnicastPkts) {
        valueLeafFlags.set(LeafIdentifier.OUTUNICASTPKTS.getLeafIndex());
        this.outUnicastPkts = outUnicastPkts;
    }

    @Override
    public void outBroadcastPkts(Counter64 outBroadcastPkts) {
        valueLeafFlags.set(LeafIdentifier.OUTBROADCASTPKTS.getLeafIndex());
        this.outBroadcastPkts = outBroadcastPkts;
    }

    @Override
    public void outMulticastPkts(Counter64 outMulticastPkts) {
        valueLeafFlags.set(LeafIdentifier.OUTMULTICASTPKTS.getLeafIndex());
        this.outMulticastPkts = outMulticastPkts;
    }

    @Override
    public void outDiscards(Counter32 outDiscards) {
        valueLeafFlags.set(LeafIdentifier.OUTDISCARDS.getLeafIndex());
        this.outDiscards = outDiscards;
    }

    @Override
    public void outErrors(Counter32 outErrors) {
        valueLeafFlags.set(LeafIdentifier.OUTERRORS.getLeafIndex());
        this.outErrors = outErrors;
    }

    @Override
    public int hashCode() {
        return Objects.hash(discontinuityTime, inOctets, inUnicastPkts, inBroadcastPkts, inMulticastPkts, inDiscards, inErrors, inUnknownProtos, outOctets, outUnicastPkts, outBroadcastPkts, outMulticastPkts, outDiscards, outErrors, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultStatistics) {
            DefaultStatistics other = (DefaultStatistics) obj;
            return
                Objects.deepEquals(discontinuityTime, other.discontinuityTime) &&
                Objects.deepEquals(inOctets, other.inOctets) &&
                Objects.deepEquals(inUnicastPkts, other.inUnicastPkts) &&
                Objects.deepEquals(inBroadcastPkts, other.inBroadcastPkts) &&
                Objects.deepEquals(inMulticastPkts, other.inMulticastPkts) &&
                Objects.deepEquals(inDiscards, other.inDiscards) &&
                Objects.deepEquals(inErrors, other.inErrors) &&
                Objects.deepEquals(inUnknownProtos, other.inUnknownProtos) &&
                Objects.deepEquals(outOctets, other.outOctets) &&
                Objects.deepEquals(outUnicastPkts, other.outUnicastPkts) &&
                Objects.deepEquals(outBroadcastPkts, other.outBroadcastPkts) &&
                Objects.deepEquals(outMulticastPkts, other.outMulticastPkts) &&
                Objects.deepEquals(outDiscards, other.outDiscards) &&
                Objects.deepEquals(outErrors, other.outErrors) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("discontinuityTime=" + discontinuityTime)
            .add("inOctets=" + inOctets)
            .add("inUnicastPkts=" + inUnicastPkts)
            .add("inBroadcastPkts=" + inBroadcastPkts)
            .add("inMulticastPkts=" + inMulticastPkts)
            .add("inDiscards=" + inDiscards)
            .add("inErrors=" + inErrors)
            .add("inUnknownProtos=" + inUnknownProtos)
            .add("outOctets=" + outOctets)
            .add("outUnicastPkts=" + outUnicastPkts)
            .add("outBroadcastPkts=" + outBroadcastPkts)
            .add("outMulticastPkts=" + outMulticastPkts)
            .add("outDiscards=" + outDiscards)
            .add("outErrors=" + outErrors)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultStatistics.
     */
    public DefaultStatistics() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}