/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface;

/**
 * Represents ENUM data of adminStatusEnum.
 */
public enum AdminStatusEnum {

    /**
     * Represents up.
     */
    UP(1, "up"),

    /**
     * Represents down.
     */
    DOWN(2, "down"),

    /**
     * Represents testing.
     */
    TESTING(3, "testing");

    private int adminStatusEnum;
    private String schemaName;

    /**
     * Creates an instance of adminStatusEnum.
     *
     * @param adminStatusEnum value of adminStatusEnum
     */
     AdminStatusEnum(int adminStatusEnum, String schemaName) {
        this.adminStatusEnum = adminStatusEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of adminStatusEnum for.
     *
     * @param value value of adminStatusEnum for
     * @return adminStatusEnum for
     */
    public static AdminStatusEnum of(int value) {
        switch (value) {
            case 1:
                return AdminStatusEnum.UP;
            case 2:
                return AdminStatusEnum.DOWN;
            case 3:
                return AdminStatusEnum.TESTING;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of adminStatusEnum for.
     *
     * @param value value of adminStatusEnum for
     * @return adminStatusEnum for
     */
    public static AdminStatusEnum of(String value) {
        switch (value) {
            case "up":
                return AdminStatusEnum.UP;
            case "down":
                return AdminStatusEnum.DOWN;
            case "testing":
                return AdminStatusEnum.TESTING;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute adminStatusEnum.
     *
     * @return adminStatusEnum value of adminStatusEnum
     */
    public int adminStatusEnum() {
        return adminStatusEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
