/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.InterfaceType;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface.AdminStatusEnum;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface.OperStatusEnum;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface.Statistics;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Gauge64;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.PhysAddress;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of yangAutoPrefixInterface.
 */
public interface YangAutoPrefixInterface extends Augmentable  {

    /**
     * Identify the leaf of YangAutoPrefixInterface.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents type.
         */
        TYPE(2),
        /**
         * Represents adminStatus.
         */
        ADMINSTATUS(3),
        /**
         * Represents operStatus.
         */
        OPERSTATUS(4),
        /**
         * Represents lastChange.
         */
        LASTCHANGE(5),
        /**
         * Represents ifIndex.
         */
        IFINDEX(6),
        /**
         * Represents physAddress.
         */
        PHYSADDRESS(7),
        /**
         * Represents speed.
         */
        SPEED(8),
        /**
         * Represents higherLayerIf.
         */
        HIGHERLAYERIF(9),
        /**
         * Represents lowerLayerIf.
         */
        LOWERLAYERIF(10);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends InterfaceType> type();

    /**
     * Returns the attribute adminStatus.
     *
     * @return adminStatus value of adminStatus
     */
    AdminStatusEnum adminStatus();

    /**
     * Returns the attribute operStatus.
     *
     * @return operStatus value of operStatus
     */
    OperStatusEnum operStatus();

    /**
     * Returns the attribute lastChange.
     *
     * @return lastChange value of lastChange
     */
    DateAndTime lastChange();

    /**
     * Returns the attribute ifIndex.
     *
     * @return ifIndex value of ifIndex
     */
    int ifIndex();

    /**
     * Returns the attribute physAddress.
     *
     * @return physAddress value of physAddress
     */
    PhysAddress physAddress();

    /**
     * Returns the attribute speed.
     *
     * @return speed value of speed
     */
    Gauge64 speed();

    /**
     * Returns the attribute higherLayerIf.
     *
     * @return higherLayerIf list of higherLayerIf
     */
    List<String> higherLayerIf();

    /**
     * Returns the attribute lowerLayerIf.
     *
     * @return lowerLayerIf list of lowerLayerIf
     */
    List<String> lowerLayerIf();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute statistics.
     *
     * @return statistics value of statistics
     */
    Statistics statistics();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends InterfaceType> type);

    /**
     * Sets the attribute adminStatus.
     *
     * @param adminStatus value of adminStatus
     */
    void adminStatus(AdminStatusEnum adminStatus);

    /**
     * Sets the attribute operStatus.
     *
     * @param operStatus value of operStatus
     */
    void operStatus(OperStatusEnum operStatus);

    /**
     * Sets the attribute lastChange.
     *
     * @param lastChange value of lastChange
     */
    void lastChange(DateAndTime lastChange);

    /**
     * Sets the attribute ifIndex.
     *
     * @param ifIndex value of ifIndex
     */
    void ifIndex(int ifIndex);

    /**
     * Sets the attribute physAddress.
     *
     * @param physAddress value of physAddress
     */
    void physAddress(PhysAddress physAddress);

    /**
     * Sets the attribute speed.
     *
     * @param speed value of speed
     */
    void speed(Gauge64 speed);

    /**
     * Sets the attribute higherLayerIf.
     *
     * @param higherLayerIf list of higherLayerIf
     */
    void higherLayerIf(List<String> higherLayerIf);

    /**
     * Sets the attribute lowerLayerIf.
     *
     * @param lowerLayerIf list of lowerLayerIf
     */
    void lowerLayerIf(List<String> lowerLayerIf);

    /**
     * Sets the attribute statistics.
     *
     * @param statistics value of statistics
     */
    void statistics(Statistics statistics);

    /**
     * Adds to the list of higherLayerIf.
     *
     * @param addTo value of higherLayerIf
     */
    void addToHigherLayerIf(String addTo);

    /**
     * Adds to the list of lowerLayerIf.
     *
     * @param addTo value of lowerLayerIf
     */
    void addToLowerLayerIf(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}