/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfaces.yangautoprefixinterface;

/**
 * Represents ENUM data of linkUpDownTrapEnableEnum.
 */
public enum LinkUpDownTrapEnableEnum {

    /**
     * Represents enabled.
     */
    ENABLED(1, "enabled"),

    /**
     * Represents disabled.
     */
    DISABLED(2, "disabled");

    private int linkUpDownTrapEnableEnum;
    private String schemaName;

    /**
     * Creates an instance of linkUpDownTrapEnableEnum.
     *
     * @param linkUpDownTrapEnableEnum value of linkUpDownTrapEnableEnum
     */
     LinkUpDownTrapEnableEnum(int linkUpDownTrapEnableEnum, String schemaName) {
        this.linkUpDownTrapEnableEnum = linkUpDownTrapEnableEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of linkUpDownTrapEnableEnum for.
     *
     * @param value value of linkUpDownTrapEnableEnum for
     * @return linkUpDownTrapEnableEnum for
     */
    public static LinkUpDownTrapEnableEnum of(int value) {
        switch (value) {
            case 1:
                return LinkUpDownTrapEnableEnum.ENABLED;
            case 2:
                return LinkUpDownTrapEnableEnum.DISABLED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of linkUpDownTrapEnableEnum for.
     *
     * @param value value of linkUpDownTrapEnableEnum for
     * @return linkUpDownTrapEnableEnum for
     */
    public static LinkUpDownTrapEnableEnum of(String value) {
        switch (value) {
            case "enabled":
                return LinkUpDownTrapEnableEnum.ENABLED;
            case "disabled":
                return LinkUpDownTrapEnableEnum.DISABLED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute linkUpDownTrapEnableEnum.
     *
     * @return linkUpDownTrapEnableEnum value of linkUpDownTrapEnableEnum
     */
    public int linkUpDownTrapEnableEnum() {
        return linkUpDownTrapEnableEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
