/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfaces;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.InterfaceType;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfaces.yangautoprefixinterface.LinkUpDownTrapEnableEnum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of yangAutoPrefixInterface.
 */
public interface YangAutoPrefixInterface extends Augmentable  {

    /**
     * Identify the leaf of YangAutoPrefixInterface.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents description.
         */
        DESCRIPTION(2),
        /**
         * Represents type.
         */
        TYPE(3),
        /**
         * Represents enabled.
         */
        ENABLED(4),
        /**
         * Represents linkUpDownTrapEnable.
         */
        LINKUPDOWNTRAPENABLE(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute description.
     *
     * @return description value of description
     */
    String description();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends InterfaceType> type();

    /**
     * Returns the attribute enabled.
     *
     * @return enabled value of enabled
     */
    boolean enabled();

    /**
     * Returns the attribute linkUpDownTrapEnable.
     *
     * @return linkUpDownTrapEnable value of linkUpDownTrapEnable
     */
    LinkUpDownTrapEnableEnum linkUpDownTrapEnable();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute description.
     *
     * @param description value of description
     */
    void description(String description);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends InterfaceType> type);

    /**
     * Sets the attribute enabled.
     *
     * @param enabled value of enabled
     */
    void enabled(boolean enabled);

    /**
     * Sets the attribute linkUpDownTrapEnable.
     *
     * @param linkUpDownTrapEnable value of linkUpDownTrapEnable
     */
    void linkUpDownTrapEnable(LinkUpDownTrapEnableEnum linkUpDownTrapEnable);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}