/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces;

/**
 * Represents the implementation of interfaceType.
 */
public abstract class InterfaceType {

    /**
     * Returns the attribute interface-type.
     *
     * @return interface-type value of interface-type
     */
    public static String interfaceTypeToString() {
        return "interface-type";
    }

    /**
     * Returns the object of interfaceType fromString input String interfaceType.
     *
     * @param valInString value of input String
     * @return interfaceType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("interface-type")) {
            return InterfaceType.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}