/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.subscriptions;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of subscription.
 */
public class SubscriptionKeys implements KeyInfo<DefaultSubscription> {
    protected SubscriptionId subscriptionId;
    /**
     * Returns the attribute subscriptionId.
     *
     * @return subscriptionId value of subscriptionId
     */
    public SubscriptionId subscriptionId() {
        return subscriptionId;
    }

    /**
     * Sets the value to attribute subscriptionId.
     *
     * @param subscriptionId value of subscriptionId
     */
    public void subscriptionId(SubscriptionId subscriptionId) {
        this.subscriptionId = subscriptionId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(subscriptionId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubscriptionKeys) {
            SubscriptionKeys other = (SubscriptionKeys) obj;
            return
                Objects.deepEquals(subscriptionId, other.subscriptionId);
        }
        return false;
    }
}