/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.receiverinfo.receivers;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.TransportProtocol;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Host;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.PortNumber;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of receiver.
 */
public interface Receiver extends Augmentable  {

    /**
     * Identify the leaf of Receiver.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents address.
         */
        ADDRESS(1),
        /**
         * Represents port.
         */
        PORT(2),
        /**
         * Represents protocol.
         */
        PROTOCOL(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute address.
     *
     * @return address value of address
     */
    Host address();

    /**
     * Returns the attribute port.
     *
     * @return port value of port
     */
    PortNumber port();

    /**
     * Returns the attribute protocol.
     *
     * @return protocol value of protocol
     */
    TransportProtocol protocol();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute address.
     *
     * @param address value of address
     */
    void address(Host address);

    /**
     * Sets the attribute port.
     *
     * @param port value of port
     */
    void port(PortNumber port);

    /**
     * Sets the attribute protocol.
     *
     * @param protocol value of protocol
     */
    void protocol(TransportProtocol protocol);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}