/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.pushsource;

/**
 * Represents ENUM data of pushSourceEnum.
 */
public enum PushSourceEnum {

    /**
     * Represents interface-originated.
     */
    INTERFACE_ORIGINATED(0, "interface-originated"),

    /**
     * Represents address-originated.
     */
    ADDRESS_ORIGINATED(1, "address-originated");

    private int pushSourceEnum;
    private String schemaName;

    /**
     * Creates an instance of pushSourceEnum.
     *
     * @param pushSourceEnum value of pushSourceEnum
     */
     PushSourceEnum(int pushSourceEnum, String schemaName) {
        this.pushSourceEnum = pushSourceEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of pushSourceEnum for.
     *
     * @param value value of pushSourceEnum for
     * @return pushSourceEnum for
     */
    public static PushSourceEnum of(int value) {
        switch (value) {
            case 0:
                return PushSourceEnum.INTERFACE_ORIGINATED;
            case 1:
                return PushSourceEnum.ADDRESS_ORIGINATED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of pushSourceEnum for.
     *
     * @param value value of pushSourceEnum for
     * @return pushSourceEnum for
     */
    public static PushSourceEnum of(String value) {
        switch (value) {
            case "interface-originated":
                return PushSourceEnum.INTERFACE_ORIGINATED;
            case "address-originated":
                return PushSourceEnum.ADDRESS_ORIGINATED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute pushSourceEnum.
     *
     * @return pushSourceEnum value of pushSourceEnum
     */
    public int pushSourceEnum() {
        return pushSourceEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
