/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.deletesubscription;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionResultTypedef;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of deleteSubscriptionOutput.
 */
public class DefaultDeleteSubscriptionOutput extends InnerModelObject implements DeleteSubscriptionOutput {
    protected SubscriptionResultTypedef subscriptionResult;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public SubscriptionResultTypedef subscriptionResult() {
        return subscriptionResult;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void subscriptionResult(SubscriptionResultTypedef subscriptionResult) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONRESULT.getLeafIndex());
        this.subscriptionResult = subscriptionResult;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptionResult, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDeleteSubscriptionOutput) {
            DefaultDeleteSubscriptionOutput other = (DefaultDeleteSubscriptionOutput) obj;
            return
                Objects.deepEquals(subscriptionResult, other.subscriptionResult) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptionResult=" + subscriptionResult)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultDeleteSubscriptionOutput.
     */
    public DefaultDeleteSubscriptionOutput() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}