/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.createsubscription;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Encoding;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.StreamTypedef;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.basefilter.FilterType;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of createSubscriptionInput.
 */
public interface CreateSubscriptionInput extends Augmentable  {

    /**
     * Identify the leaf of CreateSubscriptionInput.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents stream.
         */
        STREAM(1),
        /**
         * Represents encoding.
         */
        ENCODING(2),
        /**
         * Represents startTime.
         */
        STARTTIME(3),
        /**
         * Represents stopTime.
         */
        STOPTIME(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute stream.
     *
     * @return stream value of stream
     */
    StreamTypedef stream();

    /**
     * Returns the attribute encoding.
     *
     * @return encoding value of encoding
     */
    Encoding encoding();

    /**
     * Returns the attribute startTime.
     *
     * @return startTime value of startTime
     */
    DateAndTime startTime();

    /**
     * Returns the attribute stopTime.
     *
     * @return stopTime value of stopTime
     */
    DateAndTime stopTime();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute filterType.
     *
     * @return filterType value of filterType
     */
    FilterType filterType();

    /**
     * Sets the attribute stream.
     *
     * @param stream value of stream
     */
    void stream(StreamTypedef stream);

    /**
     * Sets the attribute encoding.
     *
     * @param encoding value of encoding
     */
    void encoding(Encoding encoding);

    /**
     * Sets the attribute startTime.
     *
     * @param startTime value of startTime
     */
    void startTime(DateAndTime startTime);

    /**
     * Sets the attribute stopTime.
     *
     * @param stopTime value of stopTime
     */
    void stopTime(DateAndTime stopTime);

    /**
     * Sets the attribute filterType.
     *
     * @param filterType value of filterType
     */
    void filterType(FilterType filterType);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}