/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.Http2;
import java.util.Objects;

/**
 * Represents the implementation of transportProtocol.
 */
public final class TransportProtocol {

    private Class<? extends Transport> identityref;

    /**
     * Creates an instance of transportProtocol.
     */
    private TransportProtocol() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public TransportProtocol(Class<? extends Transport> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of transportProtocol for type identityref.
     *
     * @param value value of transportProtocol for type identityref
     * @return transportProtocol for type identityref
     */
    public static TransportProtocol of(Class<? extends Transport> value) {
        return new TransportProtocol(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends Transport> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends Transport> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransportProtocol) {
            TransportProtocol other = (TransportProtocol) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(Transport.class)) {
            return Transport.transportToString();
        } else if (identityref.equals(Netconf.class)) {
            return Netconf.netconfToString();
        } else if (identityref.equals(Http2.class)) {
            return Http2.http2ToString();
        }
        return null;
    }
    /**
     * Returns the object of transportProtocol fromString input String transportProtocol.
     *
     * @param valInString value of input String
     * @return transportProtocol
     */
    public static TransportProtocol fromString(String valInString) {
        try {
            Class<? extends Transport> tmpVal = Transport.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
