/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of subscriptionTerminated.
 */
public interface SubscriptionTerminated extends Augmentable  {

    /**
     * Identify the leaf of SubscriptionTerminated.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents subscriptionId.
         */
        SUBSCRIPTIONID(1),
        /**
         * Represents reason.
         */
        REASON(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute subscriptionId.
     *
     * @return subscriptionId value of subscriptionId
     */
    SubscriptionId subscriptionId();

    /**
     * Returns the attribute reason.
     *
     * @return reason value of reason
     */
    SubscriptionTermReason reason();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute subscriptionId.
     *
     * @param subscriptionId value of subscriptionId
     */
    void subscriptionId(SubscriptionId subscriptionId);

    /**
     * Sets the attribute reason.
     *
     * @param reason value of reason
     */
    void reason(SubscriptionTermReason reason);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}