/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.Objects;

/**
 * Represents the implementation of subscriptionTermReason.
 */
public final class SubscriptionTermReason {

    private Class<? extends SubscriptionErrors> identityref;

    /**
     * Creates an instance of subscriptionTermReason.
     */
    private SubscriptionTermReason() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public SubscriptionTermReason(Class<? extends SubscriptionErrors> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of subscriptionTermReason for type identityref.
     *
     * @param value value of subscriptionTermReason for type identityref
     * @return subscriptionTermReason for type identityref
     */
    public static SubscriptionTermReason of(Class<? extends SubscriptionErrors> value) {
        return new SubscriptionTermReason(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends SubscriptionErrors> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends SubscriptionErrors> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubscriptionTermReason) {
            SubscriptionTermReason other = (SubscriptionTermReason) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(SubscriptionErrors.class)) {
            return SubscriptionErrors.subscriptionErrorsToString();
        } else if (identityref.equals(InternalError.class)) {
            return InternalError.internalErrorToString();
        } else if (identityref.equals(NoResources.class)) {
            return NoResources.noResourcesToString();
        } else if (identityref.equals(SubscriptionDeleted.class)) {
            return SubscriptionDeleted.subscriptionDeletedToString();
        } else if (identityref.equals(Other.class)) {
            return Other.otherToString();
        }
        return null;
    }
    /**
     * Returns the object of subscriptionTermReason fromString input String subscriptionTermReason.
     *
     * @param valInString value of input String
     * @return subscriptionTermReason
     */
    public static SubscriptionTermReason fromString(String valInString) {
        try {
            Class<? extends SubscriptionErrors> tmpVal = SubscriptionErrors.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
