/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.ErrorDataNotAuthorized;
import java.util.Objects;

/**
 * Represents the implementation of subscriptionResultTypedef.
 */
public final class SubscriptionResultTypedef {

    private Class<? extends SubscriptionResultIdentity> identityref;

    /**
     * Creates an instance of subscriptionResultTypedef.
     */
    private SubscriptionResultTypedef() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public SubscriptionResultTypedef(Class<? extends SubscriptionResultIdentity> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of subscriptionResultTypedef for type identityref.
     *
     * @param value value of subscriptionResultTypedef for type identityref
     * @return subscriptionResultTypedef for type identityref
     */
    public static SubscriptionResultTypedef of(Class<? extends SubscriptionResultIdentity> value) {
        return new SubscriptionResultTypedef(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends SubscriptionResultIdentity> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends SubscriptionResultIdentity> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubscriptionResultTypedef) {
            SubscriptionResultTypedef other = (SubscriptionResultTypedef) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(SubscriptionResultIdentity.class)) {
            return SubscriptionResultIdentity.subscriptionResultToString();
        } else if (identityref.equals(Ok.class)) {
            return Ok.okToString();
        } else if (identityref.equals(Error.class)) {
            return Error.errorToString();
        } else if (identityref.equals(ErrorDataNotAuthorized.class)) {
            return ErrorDataNotAuthorized.errorDataNotAuthorizedToString();
        } else if (identityref.equals(ErrorOther.class)) {
            return ErrorOther.errorOtherToString();
        } else if (identityref.equals(ErrorConfiguredSubscription.class)) {
            return ErrorConfiguredSubscription.errorConfiguredSubscriptionToString();
        } else if (identityref.equals(ErrorInsufficientResources.class)) {
            return ErrorInsufficientResources.errorInsufficientResourcesToString();
        } else if (identityref.equals(ErrorNoSuchOption.class)) {
            return ErrorNoSuchOption.errorNoSuchOptionToString();
        } else if (identityref.equals(ErrorNoSuchSubscription.class)) {
            return ErrorNoSuchSubscription.errorNoSuchSubscriptionToString();
        }
        return null;
    }
    /**
     * Returns the object of subscriptionResultTypedef fromString input String subscriptionResultTypedef.
     *
     * @param valInString value of input String
     * @return subscriptionResultTypedef
     */
    public static SubscriptionResultTypedef fromString(String valInString) {
        try {
            Class<? extends SubscriptionResultIdentity> tmpVal = SubscriptionResultIdentity.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
