/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of subscriptionErrors.
 */
public abstract class SubscriptionErrors {

    /**
     * Returns the attribute subscription-errors.
     *
     * @return subscription-errors value of subscription-errors
     */
    public static String subscriptionErrorsToString() {
        return "subscription-errors";
    }

    /**
     * Returns the object of subscriptionErrors fromString input String subscriptionErrors.
     *
     * @param valInString value of input String
     * @return subscriptionErrors
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("subscription-errors")) {
            return SubscriptionErrors.class;
        } else if (valInString.equals("internal-error")) {
            return InternalError.class;
        } else if (valInString.equals("no-resources")) {
            return NoResources.class;
        } else if (valInString.equals("subscription-deleted")) {
            return SubscriptionDeleted.class;
        } else if (valInString.equals("other")) {
            return Other.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}