/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.CustomStream;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.YangPush;

/**
 * Represents the implementation of streamIdentity.
 */
public abstract class StreamIdentity {

    /**
     * Returns the attribute stream.
     *
     * @return stream value of stream
     */
    public static String streamToString() {
        return "stream";
    }

    /**
     * Returns the object of streamIdentity fromString input String streamIdentity.
     *
     * @param valInString value of input String
     * @return streamIdentity
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("stream")) {
            return StreamIdentity.class;
        } else if (valInString.equals("NETCONF1")) {
            return Netconf1.class;
        } else if (valInString.equals("yang-push")) {
            return YangPush.class;
        } else if (valInString.equals("custom-stream")) {
            return CustomStream.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}