/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.pushsource.PushSourceEnum;
import java.util.Objects;

/**
 * Represents the implementation of pushSource.
 */
public final class PushSource {

    private PushSourceEnum enumeration;

    /**
     * Creates an instance of pushSource.
     */
    private PushSource() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public PushSource(PushSourceEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of pushSource for type enumeration.
     *
     * @param value value of pushSource for type enumeration
     * @return pushSource for type enumeration
     */
    public static PushSource of(PushSourceEnum value) {
        return new PushSource(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public PushSourceEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(PushSourceEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PushSource) {
            PushSource other = (PushSource) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of pushSource fromString input String pushSource.
     *
     * @param valInString value of input String
     * @return pushSource
     */
    public static PushSource fromString(String valInString) {
        try {
            PushSourceEnum tmpVal = PushSourceEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
