/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of other.
 */
public abstract class Other extends SubscriptionErrors {

    /**
     * Returns the attribute other.
     *
     * @return other value of other
     */
    public static String otherToString() {
        return "other";
    }

    /**
     * Returns the object of other fromString input String other.
     *
     * @param valInString value of input String
     * @return other
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("other")) {
            return Other.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}