/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of netconf1.
 */
public abstract class Netconf1 extends StreamIdentity {

    /**
     * Returns the attribute nETCONF1.
     *
     * @return nETCONF1 value of nETCONF1
     */
    public static String netconf1ToString() {
        return "NETCONF1";
    }

    /**
     * Returns the object of netconf1 fromString input String netconf1.
     *
     * @param valInString value of input String
     * @return netconf1
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("NETCONF1")) {
            return Netconf1.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}