/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of subscriptionTerminated.
 */
public class DefaultSubscriptionTerminated extends InnerModelObject implements SubscriptionTerminated {
    protected SubscriptionId subscriptionId;
    protected SubscriptionTermReason reason;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public SubscriptionId subscriptionId() {
        return subscriptionId;
    }

    @Override
    public SubscriptionTermReason reason() {
        return reason;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void subscriptionId(SubscriptionId subscriptionId) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONID.getLeafIndex());
        this.subscriptionId = subscriptionId;
    }

    @Override
    public void reason(SubscriptionTermReason reason) {
        valueLeafFlags.set(LeafIdentifier.REASON.getLeafIndex());
        this.reason = reason;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptionId, reason, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSubscriptionTerminated) {
            DefaultSubscriptionTerminated other = (DefaultSubscriptionTerminated) obj;
            return
                Objects.deepEquals(subscriptionId, other.subscriptionId) &&
                Objects.deepEquals(reason, other.reason) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptionId=" + subscriptionId)
            .add("reason=" + reason)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSubscriptionTerminated.
     */
    public DefaultSubscriptionTerminated() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}